#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <linux/soundcard.h>
#include <math.h>

int soundcard_fd;

void init_audio()
{
	int bits=8,stereo=0,rate=8000;
	
        if ((soundcard_fd=open("/dev/audio", O_WRONLY, 0)) == EOF) {
		fprintf(stderr, "Cannot open sound device");
                exit(0);
        }
        
        if (ioctl(soundcard_fd, SNDCTL_DSP_SAMPLESIZE, &bits) == EOF) {
                fprintf(stderr, "Cannot set %d bits/sample\n",bits);
        }
        if (ioctl(soundcard_fd, SNDCTL_DSP_STEREO, &stereo) == EOF) {
                fprintf(stderr, "Cannot set %ld channel(s)\n",stereo+1);
        }
        if (ioctl(soundcard_fd, SNDCTL_DSP_SPEED, &rate) == EOF) {
                fprintf(stderr, "Cannot set rate %d Hz\n",rate);
        }
}

void put_audio_sample(float y)
{
	static unsigned char buf[1024];
	static int p=0;
	
	buf[p]=128+127.0*y;
	p++;
	if (p==1024) {
		p=0;
		write(soundcard_fd,buf,1024);
	}
}

float dr[2];
float di[2];

float get_carrier(int bit)
{
	static float cr=1.0;
	static float ci=0.0;
	float t;
	
	t =cr*dr[bit]-ci*di[bit];
	ci=cr*di[bit]+ci*dr[bit];
	cr=t;
	
	t=2.0-(cr*cr+ci*ci);
	cr*=t;
	ci*=t;
	
	return cr;
};

int spb;
 
void put_byte(int by)
{
	int i,j,k;
	
	for (i=0;i<spb;i++) put_audio_sample(get_carrier(0));
	for (j=0;j<8;j++) {
		k=by&1;
		by>>=1;
		for (i=0;i<spb;i++) put_audio_sample(get_carrier(k));
	}
	for (i=0;i<spb;i++) put_audio_sample(get_carrier(1));
}

main(int argc, char **argv)
{
	float f0,f1;
	int i;
	FILE *fp;
	
	if (argc<5) {
		printf("Uso: rtty_o f0 f1 baud fichero\n");
		exit(0);
	}

	f0=atof(argv[1]);
	f1=atof(argv[2]);
	
	spb=8000/atoi(argv[3]);
	
	dr[0]=cos(f0*2.0*M_PI/8000.0);
	di[0]=sin(f0*2.0*M_PI/8000.0);
	dr[1]=cos(f1*2.0*M_PI/8000.0);
	di[1]=sin(f1*2.0*M_PI/8000.0);
	
	if ((fp=fopen(argv[4],"r"))==NULL) exit(1);
	
	init_audio();

	while(!feof(fp)){
		put_byte(getc(fp));
	}
	
	fclose(fp);
	close(soundcard_fd);

}
