#include "forms.h"
#include "rtty_c.h"

#include <stdlib.h>
#include <stdio.h>
#include <sys/shm.h>
#include <sys/time.h>
#include <signal.h>
#include "common.h"
#include "fft.h"

/**************** VARIABLES GLOBALES ******************/

FD_rtty_control *fd_rtty_control;
int demodf=1;
int source=0;
float gain_eye_plot;
fsk_data *fskdp;

/**************** MEMORIA COMPARTIDA ******************/

void init_mem()
{
     int i;
     int id;
     key_t key;
     char proc_id = 'C';
     
     key = ftok ("rtty", proc_id);
     
     id = shmget (key, 0, 004);		/* default size   */
     if (id == -1) {
           perror ("shmget ...");
           exit(1);
     }
     
     fskdp = (fsk_data *)shmat (id, 0, 0); /* attach segment */
     if ((int)fskdp == -1) {
           perror ("shmat ...");
           exit(1);
           }
}
 
void end_mem()
{
     shmdt ((char *)fskdp);		/* detach segment */
}

/********************** GRAFICAS **********************/

#define NPOINTS 1024*2000/FS
#define AVERAGE	0.9

void do_FFT()
{
	complex a[NSAMPLES];
	float x[NPOINTS+8],y[NPOINTS+8];
	static float afft[NPOINTS];
	int i,j,f1,f2,off;
	
	j=fskdp->pcola; j+=NCOLA-NSAMPLES; j&=(NCOLA-1);
	for(i=0;i<NSAMPLES;i++) {
		if (source) a[i].re=fskdp->cola_filtro[j];
		else a[i].re=fskdp->cola_in[j];
		a[i].im=0.0;
		j++; j&=(NCOLA-1);
	}
	r_cosine(a);
	fft(a);
	db(a);

	/* Filtrado de la FFT */
	off=1024*500/FS;
	for (i=0;i<NPOINTS;i++) {
		afft[i]=afft[i]*AVERAGE+a[i+off].re*(1.0-AVERAGE);
	}

	/* Dibujamos marcas en las frecuencias de los filtros */
	
	f1=fskdp->f_space_idx*5+500;
	f2=fskdp->f_mark_idx*5+500;
	if (f1>f2) { i=f1; f1=f2; f2=i;	}
	
	x[7]=500;	y[7]=-MINDB;
	x[6]=f1;	y[6]=-MINDB;
	x[5]=f1;	y[5]= 40;
	x[4]=f1;	y[4]=-MINDB;
	x[3]=f2;	y[3]=-MINDB;
	x[2]=f2;	y[2]= 40;
	x[1]=f2;	y[1]=-MINDB;
	x[0]=2495;	y[0]=-MINDB;

	/* Dibujamos la transformada */
	for (i=0;i<NPOINTS;i++) {
		x[i+8]=500.0 + i*FS/1024.0;
		y[i+8]=afft[i];
	}
	fl_set_xyplot_data(fd_rtty_control->fft_xyplot,x,y,NPOINTS+8,"","","");
}

#define NTRACE 10

void do_EYE()
{
	int i,j,k,l,nsch,ntot;
	float a,x[NCOLA+NTRACE+NTRACE],y[NCOLA+NTRACE+NTRACE];
	float er;

	if (fskdp->hdlc) a=8;
	else {
		a=fskdp->nstop+fskdp->nbit+1;
		if(fskdp->paridad) a+=1;
	}
	a*=fskdp->spb;
	nsch=a;

	ntot=NCOLA/nsch; if (ntot>NTRACE) ntot=NTRACE;
	i=fskdp->pcola;
	i-=nsch*ntot; while (i<0) i+=NCOLA;

	er=0;
	for (k=l=0;k<ntot;k++) {
		x[l]=-er; y[l++]=0;
		for (j=0;j<nsch;j++) {
			x[l]=j-er;
			y[l]=fskdp->cola_demod[i++];
			i&=(NCOLA-1);
			l++;
		}
		x[l]=nsch-1-er; y[l++]=0;
		er+=(a-nsch);
	}

	fl_set_xyplot_xbounds(fd_rtty_control->eye_xyplot,0,nsch-er);
	fl_set_xyplot_data(fd_rtty_control->eye_xyplot,x,y,(nsch+2)*ntot,"","","");
}


/*********************** MAIN *************************/

int main(int argc, char *argv[])
{
   float f1,f2,baud;
   int i,eyec=0;
   static int      bwi[NBW]=BWLIST;
   char buf[40];
   
   init_mem();
   atexit(end_mem);

   fl_initialize(&argc, argv, 0, 0, 0);
   fd_rtty_control = create_form_rtty_control();

   /* fill-in form initialization code */
  
   fl_set_button(fd_rtty_control->demod,1);
   fl_set_button(fd_rtty_control->FFT_in,1);
   
   sprintf(buf,"%d",bwi[fskdp->bw]);
   fl_set_object_label(fd_rtty_control->bwbox,buf);

   baud=FS/fskdp->spb;
   sprintf(buf,"%4.1f",baud);
   fl_set_input(fd_rtty_control->bps_input,buf);

   f1=fskdp->f_space_idx*5+500;
   f2=fskdp->f_mark_idx*5+500;
   fl_set_counter_value(fd_rtty_control->space_f,f1);
   fl_set_counter_value(fd_rtty_control->mark_f,f2);
   fl_set_counter_value(fd_rtty_control->nbits,fskdp->nbit);
   fl_set_counter_value(fd_rtty_control->nstop,fskdp->nstop);
   fl_set_choice(fd_rtty_control->parity,fskdp->paridad+1);
   
   gain_eye_plot=fl_get_slider_value(fd_rtty_control->eye_amp);

   fl_set_xyplot_ybounds(fd_rtty_control->eye_xyplot,-gain_eye_plot,gain_eye_plot);
   fl_set_xyplot_ybounds(fd_rtty_control->fft_xyplot,-MINDB,40);


   /* show the first form */

   fl_show_form(fd_rtty_control->rtty_control,FL_PLACE_CENTERFREE,FL_FULLBORDER,"rtty_control");

   for(;;) {
   	fl_check_forms();
	do_FFT();
   	
   	if (demodf) {
   		if (!eyec) {
   			do_EYE();
   			eyec=20;
   		} else {
   			eyec--;
   			usleep(50000);
   		}
   	}
   	usleep(50000);
   }
}
