#include <stdlib.h>
#include <math.h>
#include "forms.h"
#include "rtty_c.h"
#include "common.h"

/**************** VARIABLES GLOBALES ******************/

extern FD_rtty_control *fd_rtty_control;
extern int demodf;
extern int source;
extern float gain_eye_plot;

extern fsk_data *fskdp;

/******************** CALLBACKS ********************/

/* callbacks and freeobj handles for form rtty_control */
void space_f(FL_OBJECT *ob, long data)
{
	float f;
	f=fl_get_counter_value(ob);
	fskdp->f_space_idx=(f-500)/5;
}

void mark_f(FL_OBJECT *ob, long data)
{
	float f;
	f=fl_get_counter_value(ob);
	fskdp->f_mark_idx=(f-500)/5;
}

void swap(FL_OBJECT *ob, long data)
{
	float f1,f2;
	f1=fskdp->f_space_idx*5+500;
	f2=fskdp->f_mark_idx*5+500;
	fl_set_counter_value(fd_rtty_control->space_f,f2);
	fl_set_counter_value(fd_rtty_control->mark_f,f1);
	fskdp->f_space_idx=(f2-500)/5;
	fskdp->f_mark_idx=(f1-500)/5;
}

void nbits(FL_OBJECT *ob, long data)
{
	fskdp->nbit=fl_get_counter_value(ob);
}

void nstop(FL_OBJECT *ob, long data)
{
	fskdp->nstop=fl_get_counter_value(ob);
}

void parity(FL_OBJECT *ob, long data)
{
	fskdp->paridad=fl_get_choice(ob)-1;
}

void exit_b(FL_OBJECT *ob, long data)
{
	exit(0);
}

void demod(FL_OBJECT *ob, long data)
{
	demodf=1;
}

void stop_b(FL_OBJECT *ob, long data)
{
	demodf=0;
}

void FFT_filter(FL_OBJECT *ob, long data)
{
	source=1;
}

void FFT_in(FL_OBJECT *ob, long data)
{
	source=0;
}

void eye_amp(FL_OBJECT *ob, long data)
{
	gain_eye_plot=fl_get_slider_value(ob);
	fl_set_xyplot_ybounds(fd_rtty_control->eye_xyplot,-gain_eye_plot,gain_eye_plot);
}

void bw(FL_OBJECT *ob, long data)
{
	static int	bwi[NBW]=BWLIST;
	char buf[20];

	if (data<0 && fskdp->bw>0) fskdp->bw--;
	if (data>0 && fskdp->bw<NBW-1) fskdp->bw++;
	sprintf(buf,"%d",bwi[fskdp->bw]);
	fl_set_object_label(fd_rtty_control->bwbox,buf);
}

void bps_input(FL_OBJECT *ob, long data)
{
	float baud;
	char buf[40];
	
	baud=atof(fl_get_input(ob));
	fskdp->spb=FS/baud;
	baud=FS/fskdp->spb;
	sprintf(buf,"%4.1f",baud);
	fl_set_input(ob,buf);
}

#define NBAUD 12
float baudt[NBAUD]={44,50,75,100,110,120,134,150,200,300,600,1200};

void bpsu(FL_OBJECT *ob, long data)
{
	int i,p;
	float baud,b,erro;
	char buf[40];

	baud=FS/fskdp->spb;
	erro=1e6;
	for (i=0;i<NBAUD;i++) {
		b=fabs(baudt[i]-baud);
		if (b<erro) {
			erro=b;
			p=i;
		}
	}

	if (p==11) return;
	p++;
	baud=baudt[p];
	fskdp->spb=FS/baud;
	baud=FS/fskdp->spb;
	sprintf(buf,"%4.1f",baud);
	fl_set_input(fd_rtty_control->bps_input,buf);
}

void bpsd(FL_OBJECT *ob, long data)
{
	int i,p;
	float baud,b,erro;
	char buf[40];

	baud=FS/fskdp->spb;
	erro=1e6;
	for (i=0;i<NBAUD;i++) {
		b=fabs(baudt[i]-baud);
		if (b<erro) {
			erro=b;
			p=i;
		}
	}
	
	if (p==0) return;
	p--;
	baud=baudt[p];
	fskdp->spb=FS/baud;
	baud=FS/fskdp->spb;
	sprintf(buf,"%4.1f",baud);
	fl_set_input(fd_rtty_control->bps_input,buf);
}

void hdlc_button(FL_OBJECT *ob, long data)
{
	fskdp->hdlc=fl_get_button(ob);
}
