#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include "rtty.h"
#include "common.h"

fsk_data *fskdp;

int ipc_id;

void init_mem()
{
	int id;
	key_t key;
	char proc_id = 'C';
        int size = sizeof(fsk_data);
	int flags = 0664 | IPC_CREAT;

	key = ftok ("rtty", proc_id);
	ipc_id=id = shmget (key, size, flags);
	if (id == -1) { perror ("shmget ..."); exit(1); }
	fskdp=(fsk_data *)shmat (id, 0, 0); /* attach segment for RDWR */
	if ((int)fskdp==-1) { perror ("shmat ..."); exit(1); }

}

void end_mem()
{
	shmdt ((char *)fskdp);
	shmctl (ipc_id, IPC_RMID, NULL);
}

main(int argc, char **argv)
{
	int i,j,a;
	unsigned char buf[4096];

	init_mem();
	atexit(end_mem);

	init_audio();

	/* Valores por defecto */

	fskdp->spb=FS/150.;	/* 150 baudios */
	fskdp->hdlc=0;		/* Modo asncrono */
	fskdp->nbit=5;		/* Baudot */
	fskdp->nstop=1.5;	/* Bits de Stop */
	fskdp->paridad=0;	/* Paridad ninguna */
	fskdp->bw=2;		/* Filtro 100 Hz */
	fskdp->f_mark_idx=270;	/* f_MARK = 1850 Hz */
	fskdp->f_space_idx=100;	/* f_SPACE = 1000 Hz */
	fskdp->pcola=0;		/* Colas vacas */

	/* Lanza Proceso de Control de RTTY */
	
	if (!fork()) {
		if (execl("rtty_c","rtty_c",NULL)==-1) exit(1);
	}

	/* Bucle de decodificacin */

	for(;;){
		if (fskdp->hdlc){
			i=hdlc(buf);
			if (!check_crc_ccitt(buf, i)) {
				printf("HDLC PKT. Len=%d bytes CRC OK\n",i-2);
				hdump(buf,i-2);
			} else {
				printf("BAD PACKET\n");
			}
			printf("\n");
		} else {
			a=serie();
			if (a>255) {
				switch(a>>8){
				case 1:	printf("<P>"); break;
				case 2: printf("<F>"); break;
				case 3: printf("<PF>"); break;
				}
			}
			a&=0xff;
			if (fskdp->nbit==5) a=baudot(a);
			printf("%c",a);
			fflush(stdout);
		}
	}
}
