#include "rtty.h"
#include "common.h"

/* Coeficientes para filtros de entrada					*/
/* Tabla de coeficientes, generada a partir del programa "mkfilter"	*/
/* Formato: coef[IDX_FREC][IDX_BW][IDX_COEF]				*/
/* IDX_COEF=0	=>	1/GAIN						*/
/* IDX_COEF=1-6	=>	Coeficientes y[n]				*/

double coef_in[400][NBW][8]={
#include "coef_in.h"
};

/* Coeficientes para filtro de salida					*/
/* Tabla de coeficientes, generada a partir del programa "mkfilter"	*/
/* Formato: coef[IDX_BW][IDX_COEF]					*/
/* IDX_COEF=0	=>	1/GAIN						*/
/* IDX_COEF=1-6	=>	Coeficientes y[n]				*/

double coef_out[NBW][8]={
#include "coef_out.h"
};


/* Filtro pasa-banda para frecuencia de MARCA */
float filtroM(float in)
{
	static double xv[8],yv[8];
	static int p=0;
	int i,j;
	double s;
	double *pc;
	
	pc=&coef_in[fskdp->f_mark_idx][fskdp->bw][0];
	xv[(p+6)&7]=in*(*pc++);
	
	s=(xv[(p+6)&7] - xv[p]) + 3 * (xv[(p+2)&7] - xv[(p+4)&7]);
	for (i=0,j=p;i<6;i++,j++) s+=yv[j&7]*(*pc++);
	yv[j&7]=s;
	p++; p&=7;
	return s;
}

/* Filtro pasa-banda para frecuencia de ESPACIO */
float filtroS(float in)
{
	static double xv[8],yv[8];
	static int p=0;
	int i,j;
	double s;
	double *pc;
	
	pc=&coef_in[fskdp->f_space_idx][fskdp->bw][0];
	xv[(p+6)&7]=in*(*pc++);
	
	s=(xv[(p+6)&7] - xv[p]) + 3 * (xv[(p+2)&7] - xv[(p+4)&7]);
	for (i=0,j=p;i<6;i++,j++) s+=yv[j&7]*(*pc++);
	yv[j&7]=s;
	p++; p&=7;
	return s;
}

/* Filtro pasa-bajos para datos demodulados */
float filtroL(float in)
{
	static double xv[8],yv[8];
	static int p=0;
	int i,j;
	double s;
	double *pc;
	
	pc=&coef_out[fskdp->bw][0];
	xv[(p+6)&7]=in*(*pc++);
	
	s=     (xv[p]       + xv[(p+6)&7]) +
	  6  * (xv[(p+1)&7] + xv[(p+5)&7]) +
	  15 * (xv[(p+2)&7] + xv[(p+4)&7]) +
	  20 *  xv[(p+3)&7];
	
	for (i=0,j=p;i<6;i++,j++) s+=yv[j&7]*(*pc++);
	yv[j&7]=s;
	p++; p&=7;
	return s;
}

