enum {
	TIPO_END,
	TIPO_ADD,
	TIPO_ADDI,
	TIPO_CMP,
	TIPO_CMPI,
	TIPO_NOT,
	TIPO_LD,
	TIPO_ST,
	TIPO_ADPC,
	TIPO_JIND,
	TIPO_LDPC,
	TIPO_LDI,
	TIPO_JR,
	TIPO_RETI
};

typedef struct {
	const char *nemo;
	const unsigned short opcode;
	const unsigned short tipo;
} insttype;

const insttype instr[]={
    "ADD", 0x0000,TIPO_ADD,
    "ADDI",0X0080,TIPO_ADDI,
    "ADC", 0X0800,TIPO_ADD,
    "ADCI",0X0880,TIPO_ADDI,
    "SUB", 0X1000,TIPO_ADD,
    "SUBI",0X1080,TIPO_ADDI,
    "SBC", 0X1800,TIPO_ADD,
    "SBCI",0X1880,TIPO_ADDI,
    "CMP", 0X2000,TIPO_CMP,
    "CMPI",0X2080,TIPO_CMPI,
    "AND", 0X2800,TIPO_ADD,
    "ANDI",0X2880,TIPO_ADDI,
    "TST", 0X3000,TIPO_CMP,
    "TSTI",0X3080,TIPO_CMPI,
    "OR",  0X3800,TIPO_ADD,
    "ORI", 0X3880,TIPO_ADDI,
	"XOR", 0X4000,TIPO_ADD,
	"XORI",0X4080,TIPO_ADDI,
	"NOT", 0X4800,TIPO_NOT,
	"NEG", 0X4880,TIPO_NOT,
	"SHR", 0X5000,TIPO_NOT,
	"SHRA",0X5080,TIPO_NOT,
	"ROR", 0X5800,TIPO_NOT,

	"LD",  0X6000,TIPO_LD,
	"ST",  0X6080,TIPO_ST,
	"ADPC",0X6800,TIPO_ADPC,

	"JIND",0X6880,TIPO_JIND,
	"RETI",0X6888,TIPO_RETI,

	"LDPC",0X7000,TIPO_LDPC,
	"LDI", 0X7800,TIPO_LDI,
	"JZ",  0X8000,TIPO_JR,
	"JNZ", 0X9000,TIPO_JR,
	"JC",  0XA000,TIPO_JR,
	"JNC", 0XB000,TIPO_JR,
	"JMI", 0XC000,TIPO_JR,
	"JPL", 0XD000,TIPO_JR,
	"JV",  0XE000,TIPO_JR,
	"JR",  0XF000,TIPO_JR,

	"",    0X0000,TIPO_END
};

