#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "dtypes.h"
#include "opcodes.h"

int modelo=1;

int muestra_instr(uint16 cop, int pc, int modo)
{
	int ra,rb,rd,op,n,nst;
	int16 desp;
	int i,j;

	if ((cop&0xF888)==0x6888) {printf("RETI"); return 0;}

	rb=cop&7;  
	n =cop&15;
	nst = (cop&8)|((cop>>8)&7);
	desp=cop & 0xfff; if (desp & 0x800) desp |=0xf000;
	ra=(cop>>4) & 7;
	rd=(cop>>8) & 7;

	op=cop&0xF880;
	if (op>=0x7000) op&=0xF800;
	if (op&0x8000) op&=0xF000;

	for (i=0;instr[i].tipo;i++) {
		if (op==instr[i].opcode) break;
	}
	if (!instr[i].tipo) printf("ILEG");
	else {
		printf("%s",instr[i].nemo);
		for (j=6-strlen(instr[i].nemo);j;j--) putchar(' ');
	}
	switch(instr[i].tipo) {
		case TIPO_ADD:	printf("R%d,R%d,R%d",rd,ra,rb); break;
		case TIPO_ADDI:	printf("R%d,R%d,0x%X",rd,ra,n); break;
		case TIPO_CMP:	printf("R%d,R%d",ra,rb); break;
		case TIPO_CMPI:	printf("R%d,0x%X",ra,n); break;
		case TIPO_NOT:	printf("R%d,R%d",rd,rb); break;
		case TIPO_LD:	if (n) printf("R%d,(R%d+%d)",rd,ra,n); 
						else printf("R%d,(R%d)",rd,ra); 
						break;
		case TIPO_ST:	if (nst) printf("(R%d+%d),R%d",ra,nst,rb);
						else printf("(R%d),R%d",ra,rb);
						break;
		case TIPO_ADPC:	printf("R%d,0x%X",rd,n); break;
		case TIPO_JIND:	printf("R%d",rb); break;

		case TIPO_LDPC:	printf("R%d",rd); return 1;

		case TIPO_LDI:	printf("R%d,0x%X",rd,cop&0xff); break;
		case TIPO_JR:	printf("0x%04X",pc+desp+modelo); break;
	}
	return 0;
}

void loadhex(char *fn,int modo)
{
    int i,j,dir,ddir=-1,w=0;
    short dato;
    char *p,*pp,buf[256];
    FILE *fp;
    
    if ((fp=fopen(fn,"r"))==NULL) exit(0);
    
	j=0;
    for (dir=0;;) {
        fgets(buf,255,fp);
		if (feof(fp)) break;
		p=buf;
		if (*p=='@') {
		   dir=strtol(++p,&pp,16);
		   putchar('\n');
		   if (modo==0) printf("     ");
		   printf ("        ORG   0x%04X\n",dir);
		   continue;
		}
	
		dato=strtol(p,&pp,16);
	
		if (modo==0) printf("%04X - %04X  ",dir,dato&0xffff);
		else printf("        ");
		muestra_instr(dato,dir,modo);
		printf("\n");
		dir++;	
    }
}


main(int argc, char **argv)
{
	int i,modo=0;
	char *fn;

	if (argc<2) {
		printf("Uso: %s <-p 1/2> <-n> fichero.hex\n",argv[0]);
		exit(1);
	}
	for (i=1;i<argc;i++) {
		if (argv[i][0]=='-' && argv[i][1]=='p') { modelo=atoi(argv[++i])-1; continue;}
		if (argv[i][0]=='-' && argv[i][1]=='n') { modo=1; continue;}
		if (argv[i][0]=='-' && argv[i][1]=='h') { 
			printf("Uso: %s <-p 1/2> <-n> fichero.hex\n",argv[0]);
			exit(0);
		}
		fn=argv[i];
	}
	printf("    ; CPUMODEL = %d (%s)\n",modelo,modelo?"Pipelined Von Newmann":"1 cycle Harvard");
    loadhex(fn,modo);  
	return 0;  
}

