//-------------------------------------------------------------------

//-------------------------------------------------------------------

module tb();

//-- Registros con señales de entrada
reg clk;
reg resetb;
wire txd;

wire [15:0]xdi;
wire [15:0]xdo;
wire [15:0]xa;
wire xwe;
wire xoe;

//-- Instanciamos 


wire hsyn,vsyn;
wire [11:0]video;

SYSTEM sys1(	.clk(clk),		// Main clock input 25MHz
	.hsyn(hsyn),	// Horizontal Sync. (active low, every 32us) 
	.vsyn(vsyn),	// Vertical Sync. (active low, every 525 lines)
	.video(video),	// RGB444 output
	.reset(~resetb),
	.xwe(xwe), .xoe(xoe),
	.xa(xa),
	.xdo(xdo),
	.xdi(xdi)
);

exRAM XRAM(.addr(xa), .data_in(xdo), .data_out(xdi), .oe(xoe), .we(xwe),
			.bhe(xwe), .ble(xwe) );

// Reloj periódico
always #5 clk=~clk;

//-- Proceso al inicio
initial begin
	//-- Fichero donde almacenar los resultados
	$dumpfile("tb.vcd");
	$dumpvars(0, tb);

	resetb = 0; clk=0; 

	#7		resetb=1;
	//# 319 $display("FIN de la simulacion");
	# 300000 $finish;
	//# 1000 $finish;
end



endmodule

//----------------------------------------------------------------------------
//-- Memoria RAM asíncrona
//----------------------------------------------------------------------------

module exRAM (        
    input wire [15:0] addr,      //-- Direcciones
    input wire [15:0] data_in,   //-- Dato de entrada
    output wire [15:0] data_out,   //-- Dato a escribir
	input wire	oe,
	input wire  we,
	input wire bhe,
    input wire ble
);
  //-- Memoria
  reg [7: 0] ramh [0: 16'hffff];
  reg [7: 0] raml [0: 16'hffff];

  //-- Escritura en la memoria
  always @(negedge we) begin
    if (~ble) raml[addr] <= data_in;
    if (~bhe) ramh[addr] <= data_in;
  end

  assign    data_out = {ramh[addr],raml[addr]};

endmodule

