module SPI(
  input clk,      // Reloj principal
  input [15:0]d,  // Datos desde la CPU
  input wr0,      // strobe de escritura en datosTX
  input wr1,      // strobe de escritura en REG_control
  output [15:0]q, // Datos hacia la CPU
  output busy,    // Flag de ocupado
  output SCK,     // Señales del bus SPI
  output MOSI,
  input  MISO,
  output [3:1]SSB // Selecciones de esclavo
);

reg [7:0]cntdiv=0;    // Contador del divisor de reloj
reg [10:0]controlr=0; // Registro de control: divisor, modo, ss
wire modo;            // bit de control: 0 = 8 bits , 1 = 16 bits
// reg de control
assign modo = controlr[10];
wire rstdiv;
assign rstdiv=(cntdiv==controlr[7:0]);
always @(posedge clk) begin
    cntdiv<=(wr0|rstdiv) ? 8'h00 : cntdiv+1;
    controlr <= wr1 ? {d[15],d[9:0]} : controlr;
end
assign SSB[1] = ~((~controlr[9])&( controlr[8]));
assign SSB[2] = ~(( controlr[9])&(~controlr[8]));
assign SSB[3] = ~(( controlr[9])&( controlr[8]));

// Toggle FF para SCK
reg SCK=0;          // Reloj SPI
wire sckr, sckf;    // strobes de flanco de subida y de bajada
always @(posedge clk) SCK<=(~wr0)&busy&(SCK^rstdiv);
assign sckr = rstdiv & (~SCK);
assign sckf = rstdiv & ( SCK);

// Contador de bits
reg [4:0]cntbit=5'b11111;  // Tiene que contar hasta 16
wire bittc;                // Final de cuenta de contador de bits

assign busy = ~(cntbit[4]|(cntbit[3]&(~modo))); // flag de BUSY
always @(posedge clk) 
  cntbit= wr0 ? 0 :(busy ? (sckf ? (cntbit+1) : cntbit) : 5'b11111);

// reg de desplazamiento
reg [7:0]shh=0; // byte alto
reg [7:0]shl=0; // byte bajo
reg misoreg;    // MISO retardado medio ciclo
always @(posedge clk) begin
    shh <= wr0 ? d[15:8] :(sckf ? {shh[6:0],(shl[7]&modo)} : shh);
    shl <= wr0 ? d[7:0]  :(sckf ? {shl[6:0],misoreg} : shl);
    misoreg <= sckr ? MISO : misoreg;
end

assign q = {shh,shl};
assign MOSI = modo ? shh[7] : shl[7];

endmodule

