//--------------------------------------------------------------------
// DEFENDER recreated
// by Jesús Arias
//--------------------------------------------------------------------
// This file includes stuff specific for the ICE40HX FPGA familly
// and the SIMRETRO board
// Also, "main" is the top module of the whole design

// Top module. (signals assigned to actual pins in file "pines.pcf")
module main(
	input  CLKIN, 		// Input clock from crystal oscillator (16MHz)
	output HSYN, 		// Horizontal sync. for VGA
	output VSYN, 		// Vertical sync. for VGA
	output [3:0]R,		// Red component for VGA DAC
	output [3:0]G,		// Green component for VGA DAC
	output [3:0]B,		// Blue component for VGA DAC
	inout  [15:0]XD,	// external RAM bidirectinal data bus
	output [15:0]XA,	// external RAM address bus
	output XWE,			// external RAM Write Enable (active low)
	output XOE,			// external RAM Output Enable (active low)
	output XBHE,		// external RAM Byte High Enable (active low)
	output XBLE,		// external RAM Byte Low Enable (active low)
	output JY0,		// CLK   for game controller
	output JY1,		// Latch for game controller
	output JY4,		// Vcc   for game controller
	input  JY2,		// Data input from game controller
    input  JY3,			// Other joystick port inputs
    input  JY5,
    input  JY6,

	output [3:0]PINOUT,	// Includes SCK, MOSI, and /SS (SPI)
	// SPI
	output SCK,
	output MOSI,
	input  MISO,	
	output FSS,		// Flash SS
	output SSS,		// SD SS
	
	output PWM,		// Audio
	
	output DEB0,
	output DEB1,
	
	input RXD,
	output TXD
);

//-- PLL: generates a 25MHz master clock from a 16MHz input
wire clk,pll_lock;
pll
  pll1(
	.clock_in(CLKIN),
	.clock_out(clk),
	.locked(pll_lock)
	);

// Game controller and SPI pin mappings
assign JY4=1'b1;	// Game controller power
wire [7:0]pinin;

assign XBHE=1'b0;
assign XBLE=1'b0;

// Instance of the system
SYSTEM sys1( .clk(clk), .reset(reset),
	    .hsyn(HSYN), .vsyn(VSYN), .video({R,G,B}),
		.xwe(XWE), .xoe(XOE), .xdo(xdo), .xdi(xdi), .xa(XA), 
		.pinin(pinin), .pinout(PINOUT), .pwmout(PWM), 
		.txd(TXD), .rxd(RXD),
		.sck(SCK), .mosi(MOSI), .miso(MISO), .fss(FSS), .sss(SSS),
//		, .deb0(DEB0), .deb1(DEB1)
);

// Automatic RESET pulse: Reset is held active for 255 cycles after PLL lock
wire reset;
reg [7:0]cnt=8'hff;
assign reset=(cnt!=0);

always @(posedge clk) cnt<=(reset&pll_lock) ? cnt-1: cnt;

//////////////////////////////////////////////////////
// Bidirectional data bus of the external RAM
// Tristates have to be instantiated usign the SB_IO module (specific of the ICE40 FPGA)

wire [15:0]xdi;	// internal data input bus
wire [15:0]xdo;	// internal data output bus

//////////////////////////////////////////////////////
// SB_IOs
wire oe;
assign oe=XOE; // activate tristates on writes (XOE inactive == High)

SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance0
(   .PACKAGE_PIN(   XD[0]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(       xdo[0]),
    .D_IN_0(        xdi[0]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance1
(   .PACKAGE_PIN(   XD[1]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(       xdo[1]),
    .D_IN_0(        xdi[1]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance2
(   .PACKAGE_PIN(   XD[2]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(       xdo[2]),
    .D_IN_0(        xdi[2]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance3
(   .PACKAGE_PIN(   XD[3]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(       xdo[3]),
    .D_IN_0(        xdi[3]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance4
(   .PACKAGE_PIN(   XD[4]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(       xdo[4]),
    .D_IN_0(        xdi[4]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance5
(   .PACKAGE_PIN(   XD[5]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(       xdo[5]),
    .D_IN_0(        xdi[5]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance6
(   .PACKAGE_PIN(   XD[6]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(       xdo[6]),
    .D_IN_0(        xdi[6]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance7
(   .PACKAGE_PIN(   XD[7]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(       xdo[7]),
    .D_IN_0(        xdi[7]) );

SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance8
(   .PACKAGE_PIN(   XD[8]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(      xdo[8]),
    .D_IN_0(       xdi[8]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance9
(   .PACKAGE_PIN(   XD[9]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(      xdo[9]),
    .D_IN_0(       xdi[9]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance10
(   .PACKAGE_PIN(   XD[10]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(       xdo[10]),
    .D_IN_0(        xdi[10]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance11
(   .PACKAGE_PIN(   XD[11]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(      xdo[11]),
    .D_IN_0(       xdi[11]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance12
(   .PACKAGE_PIN(   XD[12]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(      xdo[12]),
    .D_IN_0(       xdi[12]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance13
(   .PACKAGE_PIN(   XD[13]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(      xdo[13]),
    .D_IN_0(       xdi[13]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance14
(   .PACKAGE_PIN(   XD[14]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(      xdo[14]),
    .D_IN_0(       xdi[14]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance15
(   .PACKAGE_PIN(   XD[15]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(      xdo[15]),
    .D_IN_0(       xdi[15]) );

endmodule


