//-------------------------------------------------------------------
//-- Banco de pruebas 
//-------------------------------------------------------------------

module tb();

//-- Registos con señales de entrada
reg clk;
wire txd;
reg rxd;
reg reset;

//-- Instanciamos 
wire [15:0]xa;
wire [15:0]xdo;
wire [15:0]xdi;
wire oe,we,ble,bhe;

reg kclk,kdat;

SYSTEM sys(.txd(txd), .clk(clk), .rxd(rxd), .reset(reset),
			.xwe(we), .xoe(oe),.xa(xa),.xdo(xdo),.xdi(xdi),
			.xble(ble), .xbhe(bhe), .kclk(kclk), .kdat(kdat)
);
exRAM XRAM(.addr(xa), .data_in(xdo), .data_out(xdi), .oe(oe), .we(we),
			.bhe(bhe), .ble(ble) );

always #5 clk=~clk;

//-- Proceso al inicio
initial begin
	//-- Fichero donde almacenar los resultados
	$dumpfile("tb.vcd");
	$dumpvars(0, tb);

	clk=0;
	reset=1;
	rxd=1;
	kclk=1;
	kdat=1;
	
	#50 reset=0;
	#5000 rxd=0;	// start
	#250 rxd=0;	// D0
	#250 rxd=0;	// D1
	#250 rxd=0;	// D2
	#250 rxd=1;	// D3
	#250 rxd=0;	// D4
	#250 rxd=0;	// D5
	#250 rxd=0;	// D7
	#250 rxd=0;	// D7
	#250 rxd=1;	// stop

	#250 rxd=0;	// start
	#250 rxd=0;	// D0
	#250 rxd=0;	// D1
	#250 rxd=1;	// D2
	#250 rxd=0;	// D3
	#250 rxd=0;	// D4
	#250 rxd=0;	// D5
	#250 rxd=0;	// D7
	#250 rxd=1;	// D7
	#250 rxd=1;	// stop

	#250 rxd=0;	// start
	#250 rxd=0;	// D0
	#250 rxd=0;	// D1
	#250 rxd=1;	// D2
	#250 rxd=0;	// D3
	#250 rxd=0;	// D4
	#250 rxd=0;	// D5
	#250 rxd=0;	// D7
	#250 rxd=0;	// D7
	#250 rxd=1;	// stop

	#250 rxd=0;	// start
	#250 rxd=0;	// D0
	#250 rxd=0;	// D1
	#250 rxd=0;	// D2
	#250 rxd=1;	// D3
	#250 rxd=0;	// D4
	#250 rxd=0;	// D5
	#250 rxd=0;	// D7
	#250 rxd=1;	// D7
	#250 rxd=1;	// stop

	//# 319 $display("FIN de la simulacion");
	# 5000000 $finish;
end

endmodule

//----------------------------------------------------------------------------
//-- Memoria RAM asíncrona
//----------------------------------------------------------------------------

module exRAM (        
    input wire [15:0] addr,      //-- Direcciones
    input wire [15:0] data_in,   //-- Dato de entrada
    output [15:0] data_out,   //-- Dato a escribir
	input wire	oe,
	input wire  we,
	input wire bhe,
    input wire ble
);
  //-- Memoria
  reg [7: 0] ramh [0: 16'hffff];
  reg [7: 0] raml [0: 16'hffff];

  //-- Escritura en la memoria
  always @(negedge we) begin
    if (~ble) raml[addr] <= data_in;
    if (~bhe) ramh[addr] <= data_in;
  end

  //always @(negedge oe) begin
  //  data_out <= {ramh[addr],raml[addr]};
  //end
  
  assign data_out = {ramh[addr],raml[addr]};
  
endmodule

