	output "romBOOT.bin"


;--------------------------------------
;--------------------------------------
;  CODE
;--------------------------------------
;--------------------------------------

	ld	sp,$9000
	
	ld	bc,$EF3A	; SCK,MOSI: low, CSs high, Lower RAM, fast
	out	(c),c	
	
	ld	bc,$7F80	; Gate Array: ROMCS active
	out	(c),c

	; -------------- Load ZX ROM from SPI Flash -------------------
	ld	bc,$EF1E	; SCK,MOSI: low, Flash_CS low, High RAM, fast
	out	(c),c	
	ld	a,3		; Command Read
	call	spibyte
	ld	a,$7F		; MSB
	call	spibyte
	ld	a,$40
	call	spibyte
	ld	a,$00
	call	spibyte		; LSB
	ld	hl,$0000
lbuc:	call	spibyte
	ld	(hl),a
	inc	hl
	ld	a,$40
	cp	h
	jr	nz,lbuc
	ld	hl,$C000
lbuch:	call	spibyte
	ld	(hl),a
	inc	hl
	ld	a,$00
	cp	h
	jr	nz,lbuch	

	ld	bc,$EF3A	; SCK,MOSI: low, Flash_CS low, Lower RAM, fast
	out	(c),c	
	
	; Set trampoline in RAM
	ld	de,$8000
	ld	hl,tramp
	ld	bc,trampe-tramp
	ldir
	
	jp	$8000

tramp:
	ld	bc,$EF30	; SCK,MOSI: low, Flash_CS high, no boot
	out	(c),c	
	rst	0
trampe:

; ---------- SPI Transfer -------------
;
; Parameters:	A: byte to send
; Returns:	A: byte received
; Modiffies:	nothing else

spibyte:
	push	bc
	push	de
	ld	bc,$EFFF
	ld	d,8
	ld	e,a
spb1:	in	a,(c)
	sla	a
	sla	e
	rra
	and	$BF
	out	(c),a
	or	$40
	out	(c),a
	in	a,(c)
	and	1
	jr	z,spb2
	inc	e
spb2:	dec	d
	jr	nz,spb1
	in	a,(c)
	and	$BF
	out	(c),a
	ld	a,e
	pop	de
	pop	bc
	ret


