

module main(
        input  CLKIN, 
        input  RXD, 
        output TXD,
        output HSYN, 
        output VSYN, 
        output [3:0]R,
        output [3:0]G,
        output [3:0]B,
        inout  [15:0]XD,
        output [15:0]XA,
        output XWE,
        output XOE,
        output XBHE,
        output XBLE,
`ifdef NES
		output JY0,		// CLK
		output JY1,		// Latch
		output JY4,		// Vcc
`else
		input  JY0,
        input  JY1,
        input  JY4,
`endif
        input  JY2,
        input  JY3,
        input  JY5,
        input  JY6,
        
        input  MISO,

        output [7:0]PINOUT,
        output PWM,
        
    	//output [1:0]DEBUG,
        
        input KDAT,
        input KCLK
);

wire clk;
wire pll_lock;
//-- Instanciar el PLL
pll
  pll1(
	.clock_in(CLKIN),
	.clock_out(clk),
	.locked(pll_lock)
	);

wire [7:0]pinin;
assign pinin={MISO,JY6,JY5,JY4,JY3,JY2,JY1,JY0};
`ifdef NES
	assign JY4=1'b1;
`endif


SYSTEM sys1(.txd(TXD), .rxd(RXD), .clk(clk), .reset(reset),
	    .hsyn(HSYN), .vsyn(VSYN), .r(R), .g(G), .b(B),
		.xwe(XWE), .xoe(XOE), .xdo(xdo), .xdi(xdi), .xa(XA), .xbhe(XBHE), .xble(XBLE),
		.pinout(PINOUT), .pwmout(PWM), .kclk(KCLK), .kdat(KDAT), //.debug(DEBUG),
		.pinin(pinin)
`ifdef NES
		, .gclk(JY0), .glat(JY1), .gin(JY2)
`endif
);

wire [15:0]xdi;
wire [7:0]xdo;

// Circuito de reset interno (Hay que esperar que el PLL funcione)
wire reset;
reg [2:0]cnt=3'b111;
assign reset=(cnt!=0);

always @(posedge VSYN) cnt<=(reset) ? cnt-1: cnt;

//////////////////////////////////////////////////////
// Triestados de memoria externa
wire oe;
assign oe=XOE; // Ojo, XOE está activo en bajo => escritura en alto

SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance0
(   .PACKAGE_PIN(   XD[0]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(       xdo[0]),
    .D_IN_0(        xdi[0]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance1
(   .PACKAGE_PIN(   XD[1]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(       xdo[1]),
    .D_IN_0(        xdi[1]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance2
(   .PACKAGE_PIN(   XD[2]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(       xdo[2]),
    .D_IN_0(        xdi[2]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance3
(   .PACKAGE_PIN(   XD[3]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(       xdo[3]),
    .D_IN_0(        xdi[3]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance4
(   .PACKAGE_PIN(   XD[4]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(       xdo[4]),
    .D_IN_0(        xdi[4]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance5
(   .PACKAGE_PIN(   XD[5]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(       xdo[5]),
    .D_IN_0(        xdi[5]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance6
(   .PACKAGE_PIN(   XD[6]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(       xdo[6]),
    .D_IN_0(        xdi[6]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance7
(   .PACKAGE_PIN(   XD[7]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(       xdo[7]),
    .D_IN_0(        xdi[7]) );

SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance8
(   .PACKAGE_PIN(   XD[8]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(      xdo[0]),
    .D_IN_0(       xdi[8]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance9
(   .PACKAGE_PIN(   XD[9]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(      xdo[1]),
    .D_IN_0(       xdi[9]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance10
(   .PACKAGE_PIN(   XD[10]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(       xdo[2]),
    .D_IN_0(        xdi[10]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance11
(   .PACKAGE_PIN(   XD[11]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(      xdo[3]),
    .D_IN_0(       xdi[11]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance12
(   .PACKAGE_PIN(   XD[12]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(      xdo[4]),
    .D_IN_0(       xdi[12]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance13
(   .PACKAGE_PIN(   XD[13]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(      xdo[5]),
    .D_IN_0(       xdi[13]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance14
(   .PACKAGE_PIN(   XD[14]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(      xdo[6]),
    .D_IN_0(       xdi[14]) );
SB_IO #( .PIN_TYPE(6'b 1010_01), .PULLUP(1'b 0) ) xd_instance15
(   .PACKAGE_PIN(   XD[15]),
    .OUTPUT_ENABLE( oe   ),
    .D_OUT_0(      xdo[7]),
    .D_IN_0(       xdi[15]) );

endmodule


