#!/usr/local/bin/gnuplot -persist
#
#    
#    	G N U P L O T
#    	Unix version 3.7
#    	patchlevel 0
#    	last modified Thu Jan 14 19:34:53 BST 1999
#    
#    	Copyright(C) 1986 - 1993, 1998, 1999
#    	Thomas Williams, Colin Kelley and many others
#    
#    	Type `help` to access the on-line reference manual
#    	The gnuplot FAQ is available from
#    		<http://www.uni-karlsruhe.de/~ig25/gnuplot-faq/>
#    
#    	Send comments and requests for help to <info-gnuplot@dartmouth.edu>
#    	Send bugs, suggestions and mods to <bug-gnuplot@dartmouth.edu>
#    
# set terminal X11 0
# set output 'As_Si_100_8.eps'
set noclip points
set clip one
set noclip two
set bar 1.000000
set border 31 lt -1 lw 1.000
set xdata
set ydata
set zdata
set x2data
set y2data
set boxwidth
set dummy x,y
set format x "%g"
set format y "%g"
set format x2 "%g"
set format y2 "%g"
set format z "%g"
set angles radians
set nogrid
set key title ""
set key right top Right noreverse box linetype -2 linewidth 1.000 samplen 4 spacing 1 width 0
set nolabel
set label 1 "15 keV" at 30, 5e+18, 0 left norotate
set label 2 "100 keV" at 70, 2e+18, 0 left norotate
set noarrow
set nolinestyle
set nologscale
set logscale y 10
set offsets 0, 0, 0, 0
set pointsize 1
set encoding default
set nopolar
set noparametric
set view 60, 30, 1, 1
set samples 100, 100
set isosamples 10, 10
set surface
set nocontour
set clabel '%8.3g'
set mapping cartesian
set nohidden3d
set cntrparam order 4
set cntrparam linear
set cntrparam levels auto 5
set cntrparam points 5
set size ratio 0 1,1
set origin 0,0
set data style lines
set function style lines
set xzeroaxis lt -2 lw 1.000
set x2zeroaxis lt -2 lw 1.000
set yzeroaxis lt -2 lw 1.000
set y2zeroaxis lt -2 lw 1.000
set tics in
set ticslevel 0.5
set ticscale 1 0.5
set mxtics default
set mytics default
set mx2tics default
set my2tics default
set xtics border mirror norotate autofreq 
set ytics border mirror norotate autofreq 
set ztics border nomirror norotate autofreq 
set nox2tics
set noy2tics
set title "" 0.000000,0.000000  ""
set timestamp "" bottom norotate 0.000000,0.000000  ""
set rrange [ * : * ] noreverse nowriteback  # (currently [-0:10] )
set trange [ * : * ] noreverse nowriteback  # (currently [-5:5] )
set urange [ * : * ] noreverse nowriteback  # (currently [-5:5] )
set vrange [ * : * ] noreverse nowriteback  # (currently [-5:5] )
set xlabel "Depth (nm)" 0.000000,0.000000  ""
set x2label "" 0.000000,0.000000  ""
set timefmt "%d/%m/%y\n%H:%M"
set xrange [ * : 400 ] noreverse nowriteback  # (currently [-10:] )
set x2range [ * : * ] noreverse nowriteback  # (currently [-10:10] )
set ylabel "Concentration (at/cm^3)" 2.000000,0.000000  ""
set y2label "" 0.000000,0.000000  ""
set yrange [ 1e+16 : * ] noreverse nowriteback  # (currently [:10000] )
set y2range [ * : * ] noreverse nowriteback  # (currently [-10:10] )
set zlabel "" 0.000000,0.000000  ""
set zrange [ * : * ] noreverse nowriteback  # (currently [-10:10] )
set zero 1e-08
set lmargin -1
set bmargin -1
set rmargin -1
set tmargin -1
set locale "C"
plot "as_15_8.sim"t"This work" w linespoints 1,"as_15_8.test"t"Test" w l 3,"SIMS/as15_8_30.dat"t"SIMS" w l 2,"as_100_8.sim"notitle w linespoints 1,"as_100_8.test"notitle w l 3,"SIMS/as100_8_30.dat"notitle w l 2

set format y "10^{%T}"
set term postscript portrait enh monochrome dashed "Times-Roman" 10
set size 0.7, 0.35
set output "As_Si_100_8_new.eps"
replot
set term X11
set size
replot
pause -1 "Press any key"
