program pictest;                        {TEST PIC16c84}
uses crt,picunit;                       {Uses picunit}

var
  pgmmem1: pgmmemtype;                  {Program memory, copy}
  datmem1: datmemtype;                  {Data memory, copy}
  cfgmem1: cfgmemtype;                  {Config memory, copy}
  i: word;                              {Counter etc}
  ok: boolean;                          {OK flag}
  t1,t2: word;                          {Store time}
  t: word absolute 0:$46c;              {Timer}

begin
  if paramcount=1 then val(paramstr(1),com,i) else
  begin
    writeln('Use:');
    writeln('   pictest comport');
    halt;
  end;

  writeln('Testing PIC-Programmer at COM',com);

  if hwerror then                       {HW-check}
  begin
    writeln('- Programmer not connected');
    halt;
  end;

  writeln('- Erase');
  eraseall;

  write('- Blank check ');
  t1:=t;
  readall;
  ok:=true;
  for i:=0 to $3ff do if pgmmem[i]<>$3fff then ok:=false;
  t2:=t;
  writeln(ok,', ',(t2-t1)*55,'ms');

  writeln('- Generate random numbers');
  randomize;
  for i:=0 to $3ff do pgmmem[i]:=random($3fff);
  for i:=0 to $3f  do datmem[i]:=random($ff);
  pgmmem1:=pgmmem; datmem1:=datmem;

  write('- Programming random numbers, ');
  t1:=t;
  progall;
  t2:=t;
  writeln((t2-t1)*55,'ms');

  write('- Verify ');
  t1:=t;
  readall;
  ok:=true;
  for i:=0 to $3ff do if pgmmem[i]<>pgmmem1[i] then ok:=false;
  for i:=0 to $3f do if lo(datmem[i])<>lo(datmem1[i]) then ok:=false;
  t2:=t;
  writeln(ok,', ',(t2-t1)*55,'ms');

  write('- Programming ZERO''s, ');
  t1:=t;
  fillchar(pgmmem,sizeof(pgmmem),0);
  fillchar(datmem,sizeof(datmem),0);
  progall;
  t2:=t;
  writeln((t2-t1)*55,'ms');

  write('- Verify ');
  t1:=t;
  readall;
  ok:=true;
  for i:=0 to $3ff do if pgmmem[i]<>0 then ok:=false;
  for i:=0 to $3f do if lo(datmem[i])<>0 then ok:=false;
  t2:=t;
  writeln(ok,', ',(t2-t1)*55,'ms');
end.
