program picread;                                        {Read into inhx file}
uses picunit;                                           {Uses picunit}
var
  f: text;                                              {Text file}
  sum: byte;                                            {Checksum}

type
  hilo =                                                {Convert byte/words}
  record
    lo,hi: byte;
  end;

procedure wrhex(data: byte);                            {Writes hex to file}
const
  hx: array[0..15] of char =                            {Define hex chars}
    ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
begin
  sum:=sum+data;                                        {Update checksum}
  write(f,hx[data shr 4],hx[data and $f]);              {Write hex}
end;

procedure outhex(var memory; adr: word; count: byte);   {Output hex line}
var
  mem: array[1..255] of byte absolute memory;           {Memory}
  i: word;                                              {Count variable}
begin
  sum:=0;                                               {Reset checksum}
  write(f,':');                                         {Begin line}
  wrhex(count);                                         {Number of data}
  wrhex(hi(adr));                                       {High adress}
  wrhex(lo(adr));                                       {Low adress}
  wrhex(0);                                             {0 = data record}
  for i:=1 to count do wrhex(mem[i]);                   {Write data}
  wrhex(-sum);                                          {Checksum}
  writeln(f);                                           {Next line}
end;

var
  i: word;                                                       {Count}

begin
  if paramcount=2 then val(paramstr(2),com,i) else              {Get comport}
  begin                                                         {Else help}
    writeln('Use:');
    writeln('   picread filename.hex comport');
    halt;
  end;
  assign(f,paramstr(1));                                        {Open file}
  writeln('Reading PIC16C84 at COM',com,' to ''',paramstr(1),'''');     {Info}
  if hwerror then                                               {HW-check}
  begin
    writeln('- Programmer not connected');
    halt;
  end;
  readcfg;                                                      {Read config}
  if cfgmem[7] and 16 = 0 then                                  {Codeprotect?}
  begin
    writeln('Code Protected!');
    halt;
  end;
  rewrite(f);                                                   {Write mode}
  readall;                                                      {Read PIC16C84}
  for i:=0 to $3f do hilo(datmem[i]).hi:=0;                     {Clr high data}
  for i:=0 to $7f do outhex(pgmmem[i*8],i*$10,$10);             {Write pgmmem}
  outhex(cfgmem[0],$4000,8);                                    {Write id's}
  outhex(cfgmem[7],$400E,2);                                    {Write cfgword}
  for i:=0 to 7 do outhex(datmem[i*8],i*$10+$4200,$10);         {Write datmem}
  writeln(f,':00000001FF');                                     {End data}
  close(f);                                                     {Close file}
end.
